<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
  	<meta name="viewport" content="width=device-width, initial-scale=1">
  	<meta http-equiv="x-ua-compatible" content="ie=edge">
  	<title><?php echo $__env->yieldContent('header.title'); ?></title>
  	<link rel="stylesheet" href="<?php echo e(asset('bower_components/admin-lte/plugins/fontawesome-free/css/all.min.css')); ?>">
  	<link rel="stylesheet" href="<?php echo e(asset('bower_components/admin-lte/dist/css/adminlte.min.css')); ?>">
  	<link href="https://fonts.googleapis.com/css?family=Roboto&display=swap" rel="stylesheet">
  	<link rel="stylesheet" href="<?php echo e(asset('bower_components/admin-lte/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css')); ?>">
  	<link rel="stylesheet" href="<?php echo e(asset('bower_components/admin-lte/plugins/toastr/toastr.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('css/preload.css')); ?>">
  	<?php echo $__env->yieldContent('header.plugins'); ?>
  	<?php echo $__env->yieldContent('header.styles'); ?>
</head>
<body class="hold-transition sidebar-mini">
	<div class="wrapper">
		<?php echo $__env->make('apps.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<?php echo $__env->make('apps.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<div class="content-wrapper" style="font-size: 12px;">
			<?php echo $__env->yieldContent('content'); ?>
		</div>
		<div class="modal fade" id="modalMd" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
			<h4 class="modal-title" id="modalMdTitle"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
          </div>
          <div class="modal-body">
            <div class="modalError"></div>
            <div id="modalMdContent"></div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade bs-modal-lg" id="modalLg" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
          <div class="modal-header">
			<h4 class="modal-title" id="modalLgTitle"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
          </div>
          <div class="modal-body">
            <div class="modalError"></div>
            <div id="modalLgContent"></div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade bs-modal-xl" id="modalXl" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="modalXlTitle"></h4>
          </div>
          <div class="modal-body">
            <div class="modalError"></div>
            <div id="modalXlContent"></div>
          </div>
        </div>
      </div>
    </div>
    
		<?php echo $__env->make('apps.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	</div>
  <script src="<?php echo e(asset('bower_components/admin-lte/plugins/jquery/jquery.min.js')); ?>"></script>
	<script src="<?php echo e(asset('bower_components/admin-lte/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
	<script src="<?php echo e(asset('bower_components/admin-lte/dist/js/adminlte.min.js')); ?>"></script>
	<script src="<?php echo e(asset('bower_components/admin-lte/plugins/sweetalert2/sweetalert2.min.js')); ?>"></script>
	<script src="<?php echo e(asset('bower_components/admin-lte/plugins/toastr/toastr.min.js')); ?>"></script>
	<script src="<?php echo e(asset('js/admin.js')); ?>" type="text/javascript"></script>
	<script src="<?php echo e(asset('js/preload.js')); ?>" type="text/javascript"></script>
	<?php echo $__env->yieldContent('footer.scripts'); ?>
	<script type="text/javascript">
		<?php if(Session::has('message')): ?>
		var type = "<?php echo e(Session::get('alert-type', 'info')); ?>";
        	switch(type){
            	case 'info':
                	toastr.info("<?php echo e(Session::get('message')); ?>");
                	break;      
            	case 'warning':
                	toastr.warning("<?php echo e(Session::get('message')); ?>");
                	break;
           		case 'success':
                	toastr.success("<?php echo e(Session::get('message')); ?>");
                	break;
            	case 'error':
                	toastr.error("<?php echo e(Session::get('message')); ?>");
                	break;
        	}
    	<?php endif; ?>
	</script>
</body>
</html>


<?php /**PATH C:\xampp\htdocs\betterwork-master\resources\views/apps/layouts/main.blade.php ENDPATH**/ ?>